package app.firezone.synk.network.Activities;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.databinding.ActivityForgetPassChangeBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.ChangePasswordRequest;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ForgetPassChangeActivity extends AppCompatActivity {

    ActivityForgetPassChangeBinding binding;

    private MyApi myApi;
    String password;
    long userId;
    ProgressDialog progressDialog;

    private static final String TAG = "ForgetPassChangeActivity";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityForgetPassChangeBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        binding.backArrow.setOnClickListener(v -> finish());

        progressDialog = new ProgressDialog(ForgetPassChangeActivity.this);
        progressDialog.setTitle("Updating Password");
        progressDialog.setMessage("Please wait.....");

        password = getIntent().getStringExtra("password");
        userId = getIntent().getLongExtra("userId", 0);

        setupPassField(binding.pass1);
        setupPassField(binding.pass2);

        binding.btnChangePass.setOnClickListener(v -> {
            String pass1 = binding.pass1.getText().toString().trim();
            String pass2 = binding.pass2.getText().toString().trim();

            if (pass1.isEmpty() || pass2.isEmpty()) {
                Toast.makeText(ForgetPassChangeActivity.this, "All fields are required", Toast.LENGTH_SHORT).show();
                return;
            }

            if (!pass1.equals(pass2)) {
                binding.pass1.setError("Passwords do not match");
                binding.pass2.setError("Passwords do not match");
                Toast.makeText(ForgetPassChangeActivity.this, "Password and Confirm Password do not match.", Toast.LENGTH_SHORT).show();
                return;
            }

            changesPassword(pass1);
        });
    }

    private void setupPassField(EditText editText) {
        // TextWatcher to prevent spaces in the username
        editText.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                // No action needed
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                // Remove spaces from the username input
                String input = s.toString().replace(" ", "");
                if (!input.equals(s.toString())) {
                    editText.setText(input);
                    editText.setSelection(input.length()); // Move cursor to the end
                }
            }

            @Override
            public void afterTextChanged(Editable s) {
                // No action needed
            }
        });

        // OnKeyListener to prevent Enter key
        editText.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_DOWN && keyCode == KeyEvent.KEYCODE_ENTER) {
                    return true; // Consume the event, preventing Enter from being registered
                }
                return false;
            }
        });

    }

    private void changesPassword(String newPass) {
        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        ChangePasswordRequest request = new ChangePasswordRequest(userId, newPass);
        Call<ApiResponse> call = myApi.changeForgetPassword(request);

        progressDialog.show();

        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                progressDialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().getStatus() == 200 || response.body().isSuccess()) {
                        Toast.makeText(ForgetPassChangeActivity.this, "Password updated successfully!", Toast.LENGTH_SHORT).show();
                        startActivity(new Intent(ForgetPassChangeActivity.this, LoginActivity.class));
                        finish();
                    } else {
                        Toast.makeText(ForgetPassChangeActivity.this, response.body().getMessage(), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(ForgetPassChangeActivity.this, "Something went wrong", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable t) {
                progressDialog.dismiss();
                Toast.makeText(ForgetPassChangeActivity.this, "Request failed: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }


}